/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.breakpoints;

import frc.emul.debug.breakpoints.AbstractBreakpoint;
import frc.emul.debug.breakpoints.HitCounter;

public abstract class AbstractBreakpointWithCounter
extends AbstractBreakpoint {
    public static final String PROP_THRESHOLD = "counter.threshold";
    private HitCounter counter = HitCounter.INACTIVE;

    protected AbstractBreakpointWithCounter(int n) {
        super(n);
    }

    public final boolean isHitCountActive() {
        return this.counter.isActive();
    }

    public final int getHitThreshold() {
        return this.counter.getThreshold();
    }

    public final void setHitThreshold(int n) {
        if (n < 2) {
            n = 0;
        }
        int n2 = this.getHitThreshold();
        this.counter = HitCounter.convertCounter(this.counter, n);
        if (n2 != n && this.getPropSupport() != null) {
            this.getPropSupport().firePropertyChange(PROP_THRESHOLD, n2, n);
        }
    }

    protected final void resetCounter() {
        this.counter.reset();
    }

    protected final boolean hitCounter() {
        return this.counter.hit();
    }

    protected final boolean isThresholdReached() {
        return this.counter.isThresholdReached();
    }

    protected final String appendCounterDisplay(StringBuffer stringBuffer) {
        return this.counter.appendDetail(stringBuffer).toString();
    }
}

